﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Net;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
namespace Helper
{
    [ComVisible(true)]
    public static class CommonHelper
    {
        #region 自己写的
        public static int Now { get { return ConvertEx.TimeToStamp(DateTime.Now); } }

        public static bool IsDebug
        {
            get { return System.Diagnostics.Debugger.IsAttached; }
        }

        public static string GenerateCode(string s)
        {
            return s.Replace("\\", "\\\\").Replace("\"", "\\\"");
        }
        #endregion
        #region 网上抄的


        /// <summary>
        /// 二维数组转datatable
        /// </summary>
        /// <param name="arr"></param>
        /// <returns></returns>
        public static DataTable ArrayToDataTable(string[,] arr)
        {
            DataTable dt = new DataTable();
            for (int i = 0; i < arr.GetLength(1); i++)
            {
                DataColumn newColumn = new DataColumn(i.ToString(), arr[0, 0].GetType());
                dt.Columns.Add(newColumn);
            }
            for (int i = 0; i < arr.GetLength(0); i++)
            {
                DataRow newRow = dt.NewRow();
                for (int j = 0; j < arr.GetLength(1); j++)
                {
                    newRow[j.ToString()] = arr[i, j];
                }
                dt.Rows.Add(newRow);
            }
            return dt;
        }
        public static void PrintTable(DataTable table)
        {
            // print head
            foreach (DataColumn col in table.Columns)
            {
                Console.Write(string.Format("{0,12}", col.Caption));
            }
            Console.Write("\n");
            Console.WriteLine(new string('-', 12 * table.Columns.Count));
            // print rows
            for (int i = 0; i < table.Rows.Count; i++)
            {
                for (int j = 0; j < table.Columns.Count; j++)
                {
                    Console.Write(string.Format("{0,12}", table.Rows[i][j].ToString()));
                }
                Console.Write("\n");
            }
            Console.WriteLine(new string('-', 12 * table.Columns.Count));
        }

        #endregion
    }
}
